// fts_cpp_copy_bench.cpp : This file contains the 'main' function. Program execution begins and ends there.
//

#include "by_copy.h"
#include "by_ref.h"
#include "data.h"

#include <iostream>
#include <random>
#include <tuple>

int main()
{
	size_t num_shapes = 4000;
	size_t num_cycles = 5;
	size_t num_runs = 5;
	size_t num_warmup = 1;

	auto min_pos = (T)0.0;
	auto max_pos = (T)50.0;
	auto min_rad = (T)0.1;
	auto max_rad = (T)10.0;

	std::random_device r;
	std::default_random_engine eng(r());
	std::uniform_real_distribution<T> pos_dist(min_pos, max_pos);
	std::uniform_real_distribution<T> rad_dist(min_rad, max_rad);

	auto gen_pos1 = [&]() -> T { return pos_dist(eng); };
	auto gen_pos3 = [&]() -> std::tuple<T,T,T> { return std::make_tuple(gen_pos1(), gen_pos1(), gen_pos1()); };
	auto gen_rad = [&]() -> T { return rad_dist(eng); };

	int64_t total_overlaps = 0;
	int64_t total_copy = 0;
	int64_t total_ref = 0;

	std::vector<TSphere> testspheres = {
		{ { 0.f, 0.f, 0.f }, 1.f }
	};

	for (size_t cycle = 0; cycle < num_cycles; ++cycle) {
		std::vector<TSphere> spheres;
		spheres.reserve(num_shapes);
		for (size_t i = 0; i < num_shapes; ++i)
			spheres.emplace_back(gen_pos3(), gen_rad());

		std::vector<TCapsule> capsules;
		capsules.reserve(num_shapes);
		for (size_t i = 0; i < num_shapes; ++i)
			capsules.emplace_back(gen_pos3(), gen_pos3(), gen_rad());

		std::vector<TSegment> segments;
		segments.reserve(num_shapes);
		for (size_t i = 0; i < num_shapes; ++i)
			segments.emplace_back(gen_pos3(), gen_pos3());

		std::vector<TTriangle> triangles;
		triangles.reserve(num_shapes);
		for (size_t i = 0; i < num_shapes; ++i)
			triangles.emplace_back(gen_pos3(), gen_pos3(), gen_pos3());

		for (size_t run = 0; run < num_runs + num_warmup; ++run) {
			int64_t num_overlaps = 0;
			int64_t milliseconds = 0;

			std::tie(num_overlaps, milliseconds) = by_copy::run_test(spheres, capsules, segments, triangles);
			total_overlaps += num_overlaps;
			if (run >= num_warmup)
				total_copy += milliseconds;

			std::tie(num_overlaps, milliseconds) = by_ref::run_test(spheres, capsules, segments, triangles);
			total_overlaps += num_overlaps;
			if (run >= num_warmup)
				total_ref += milliseconds;
		}
	}

	std::cout << "Totals:" << std::endl;
	std::cout << "  Overlaps: " << total_overlaps << std::endl;
	std::cout << "  By-Copy: " << total_copy << std::endl;;
	std::cout << "  By-Ref: " << total_ref;
	
	auto delta = (((double)total_copy - (double)total_ref) / (double)total_copy) * -100.0;
	std::cout << "  Delta: " << (delta > 0 ? "+" : "") << delta << "%" << std::endl;
}
